-- Comp script to find a local .mov saver, find/start Fusion x86, set up a simple comp on it
-- then installs framescripts to locate the Fusion x64 and grab frames off it for the local QT saver
-- 
-- Daniel Koch, eyeon, 19-Jan-11, draft 0.5

-- might need to check these vars:
fuaddr = "localhost"
fuappname = "Fusion"
fupath = [[c:\Program Files (x86)\eyeon\Fusion 6.1\]]..fuappname..".exe"  -- is this the right default?
--fupath = [[g:\debug\Fusion.exe]]

-- some constants for the QuickTime format (could change these to e.g. AVI if desired)
FmtName = "QuickTime"
FmtID = "QuickTimeMovies"	-- Registry ID
FmtExtension = ".MOV"		-- must be caps
FmtCodec = "H.264_avc1"		-- default


-- look for a .mov saver
saverlist = comp:GetToolList(false, "Saver")
for i,t in ipairs(saverlist) do
	local filename = t.Clip[0]
	if filename and filename:sub(-4):upper() == FmtExtension then
		saver = t
		break
	end
end

if not saver then
	print("Could not find a "..FmtName.." saver")
	exit(5)
end


myuuid = bmd.getappuuid()
fuqtapp = nil	-- no no, this is actually the remote x86 Fusion that will render our QuickTime

-- Find or start a QuickTime-capable app
scriptserver = bmd.scriptapp(nil, nil, addr, 5.0)
if scriptserver then
	local tries = 0
	while not fuqtapp and tries < 6 do
		-- get list of hosts at this addr
		hostlist = scriptserver:GetHostList()
		if hostlist then
			-- look for an app that isn't ourselves
			for k,t in ipairs(hostlist) do
--				print("Found "..t.Name, t.UUID)

				if t.Name == fuappname and t.UUID ~= myuuid then
					fuqtapp = bmd.scriptapp(t.Name, addr, 10.0, t.UUID)
					if fuqtapp then
						-- check version
						appinfo = fuqtapp:GetAppInfo()
						if appinfo then
							if appinfo.Version < 6.14 or (appinfo.Version == 6.14 and (appinfo.Build < 768 and appinfo.Build ~= 0)) then 
								print(t.Name.." must be at least version 6.1.4 build 768")
								fuqtapp = nil
							end
						end

						-- check for format support
						if fuqtapp then
							if fuqtapp:FindReg(FmtID) then
								break
							else
								print(t.Name.." does not support "..FmtName)
								fuqtapp = nil
							end
						end
					end
				end
			end
			
			if not fuqtapp and tries == 0 then
				-- need to start one
				-- confirm location of 32bit version
				if not bmd.fileexists(fupath) then
					fupath = [[c:\Program Files (x86)\]]
					local dlg = iup.filedlg{ title = "Locate 32bit Fusion.exe", DIRECTORY = fupath, FILE = fuappname..".exe", FILTER = "*.exe" }
					dlg:popup(-1,-1)
					if dlg.status == "0" then
						fupath = dlg.value
						if not bmd.fileexists(fupath) then
							print("Fusion.exe not found at "..fupath)
							exit(10)
						end
					else
						print("Cancelled")
						exit(5)
					end
				end
				print("Starting "..fupath)

				bmd.executebg(fupath.." /clean")
			end
			bmd.wait(2.0)
		else
			print("No hostlist found")
		end
		tries = tries + 1
	end
else
	print("No script server found")
end

if not fuqtapp then
	print("Could not start "..fuappname)
	exit(20)
end

print("Found "..fuappname)
fuqtapp:ShowWindow(SW_SHOW)

--fuqtcomp = fuqtapp.CurrentComp		-- well, it's not so bad really
if not fuqtcomp then
	fuqtcomp = fuqtapp:NewComp()
end

-- Prevent interactive renders (keeps things simple)
fuqtcomp:Lock()

print("Found "..FmtName.." saver "..saver.Name)
savercopy = comp:CopySettings(saver)

-- Set up a simple comp on fuqtapp
fuqtbg = fuqtcomp:AddTool("Background", -1, 0)
fuqtcomp:Paste(savercopy)
fuqtsaver = fuqtcomp[saver.Name]
print("Created remote saver "..fuqtsaver.Name)

-- assemble startrenderscript
-- this script connects back to Fusion x64 - assemble with indicated fields
startrenderscript1 = "fu64 = bmd.scriptapp('"	-- ..appname
startrenderscript2 = "', '" -- ..addr
startrenderscript3 = "', 5, '" -- ..uuid
startrenderscript4 = 
[[')
if fu64 then
  comp64 = fu64.CurrentComp
  if comp64 then
    sav64 = comp64.]] -- ..savername
startrenderscript5 = "\r\n"..
[[
    if sav64 then
      in64 = sav64.Input
      out64 = in64:GetConnectedOutput()
    end
  end
end
]]

framerenderscript = 
[[
if out64 then
  local ret = out64:GetValueMemBlock(time)
  if ret then
    Input = Image(ret.Value)
  end
end
]]

startrenderscript = startrenderscript1 .. bmd.getappname() .. startrenderscript2 .. fuaddr .. startrenderscript3 .. bmd.getappuuid() .. startrenderscript4 .. fuqtsaver.Name .. startrenderscript5

fuqtsaver.StartRenderScript = startrenderscript
fuqtsaver.FrameRenderScript = framerenderscript

-- link to BG and override a few settings
fuqtsaver.Input = fuqtbg.Output
fuqtsaver.Clip = comp:MapPath(saver.Clip[0])	-- map it just to be sure
fuqtsaver.OutputFormat = FmtID
if (saver[FmtID..".Compression"]) == nil then
	fuqtsaver[FmtID..".Compression"] = FmtCodec
	-- set up any other specifc settings here, if desired
end

-- set up comp parameters like range
mycompattrs = comp:GetAttrs()
fuqtcompattrs = {
	COMPN_GlobalStart = mycompattrs.COMPN_GlobalStart,
	COMPN_GlobalEnd = mycompattrs.COMPN_GlobalEnd,
	COMPN_RenderStart = mycompattrs.COMPN_RenderStart,
	COMPN_RenderEnd = mycompattrs.COMPN_RenderEnd,
	COMPB_Modified = false,
}
fuqtcomp:SetAttrs(fuqtcompattrs)

-- view it (slows things slightly, but informative)
fuqtcomp.CurrentFrame.LeftView:GetPreview():ViewOn(fuqtsaver)

-- Eat the existing log first
logpos = 1
fuqtlog = fuqtcomp:GetConsoleHistory(logpos)
if fuqtlog and fuqtlog.Last then
    logpos = fuqtlog.Last + 1
end
print("Starting render "..mycompattrs.COMPN_RenderStart .."..".. mycompattrs.COMPN_RenderEnd)

-- and now: start the render!
oldtimeout = fuqtapp:SetTimeout(0)	-- or we only render for 10 secs
fuqtcomp:Render({Wait = true})

collectgarbage()
fuqtapp:SetTimeout(oldtimeout)

-- Display render log
fuqtlog = fuqtcomp:GetConsoleHistory(logpos)
if fuqtlog then
	comp:Print("Log:\n")
	for i,entry in ipairs(fuqtlog) do
		print(entry.Text)
	end
end

fuqtcomp:Unlock()
fuqtcomp:Close()

fu:ShowWindow(SW_SHOW)	-- show local interface again
